/*
 * @Description:5 * @Date: 2019-07-03 09:32:04
 * @Author: 吳星萍 iris@e-besthealth.com
 * @LastEditors: 吳星萍 iris@e-besthealth.com
 * @LastEditTime: 2020-06-17 11:16:29
 * @copyright: BEST HEALTH ELECTRONIC INC (c) 2019
 */
#include "common.h"
unsigned char Flash_WR_Buff[5]=
{
0x55,0x56,0x57,0x58,0x59,
};

void main()
{
	// 判斷是否為上電復位或者非正常情況下的復位
	// 如果是上電復位，執行上電復位初始化，反之執行WDT溢出初始化
	if (_to == 0 || _pdf ==0)
	{
		// System
		Drv_SysClockInit();
		SET_WDTTIME_125MS();
		SET_LVR_1V9();
		
		//EEPROM demo
		unsigned char i;
		// 1.EEPROM 寫入字節
		Write_EEPROMByte(EEPROM_addr1, 0x20);
		GCC_CLRWDT();
		
		// 2.EEPROM 寫入BUF,0x55~0x59
		Write_EEPROMBuf(EEPROM_addr2, 5,Flash_WR_Buff);
		GCC_CLRWDT();
		
		// 3.清除BUF
		for ( i = 0; i <5; i++)
		{
			Flash_WR_Buff[i] = 0x00;
		}
		GCC_CLRWDT();
		
		// 4.EEPROM讀取字節
		Read_EEPROMByte(EEPROM_addr1,Flash_WR_Buff);
		GCC_CLRWDT();
		
		// 5.清除BUF
		Flash_WR_Buff[0] = 0x00;
		
		// 6.EEPROM讀取buf
		Read_EEPROMBuf(EEPROM_addr2, 5, Flash_WR_Buff);		
		GCC_CLRWDT();
	}
	else
	{
		// WDT溢出 復位初始化
		GCC_CLRWDT();

	}
		//主循環

	while(1)
	{
		GCC_CLRWDT();
		GCC_NOP();
	}
}